/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskUpgradeChecksASMAndListener
extends Task {
    private Version m_srcRelease = null;

    public TaskUpgradeChecksASMAndListener(Version srcRelease, String[] nodeList) {
        super(nodeList);
        this.m_srcRelease = srcRelease;
    }

    @Override
    public boolean performTask() {
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("4554", false, (Object[])new String[]{m_localHost}));
        Trace.out((String)"Checking if ASM instance if configured is running from local node");
        ResultSet asmInstanceResultSet = this.checkASMInstanceConfiguredAndRunning();
        this.m_resultSet.uploadResultSet(asmInstanceResultSet);
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("4555", false, (Object[])new String[]{m_localHost}));
        Trace.out((String)"Checking if Default listener if configured is running from local node");
        ResultSet defaultListnrResultSet = this.checkDefaultListenerConfiguration();
        this.m_resultSet.uploadResultSet(defaultListnrResultSet);
        if (this.m_resultSet.getStatus() != 1) {
            this.m_resultSet.addResult(this.m_nodeList, this.m_resultSet.getStatus());
            ReportUtil.printResult(s_gMsgBundle.getMessage("4553", false));
            return false;
        }
        this.m_resultSet.addResult(this.m_nodeList, 1);
        ReportUtil.printResult(s_gMsgBundle.getMessage("4552", false));
        return true;
    }

    private ResultSet checkASMInstanceConfiguredAndRunning() {
        ResultSet asmRsltSet = new ResultSet();
        Result localNodeRes = new Result(m_localHost);
        String message = null;
        try {
            ASMDiskGroupsUtil asmDiskUtil = new ASMDiskGroupsUtil();
            ArrayList<String> runningNodeList = new ArrayList<String>();
            ArrayList<String> failedNodeList = new ArrayList<String>();
            asmDiskUtil.checkASMRunning(this.m_nodeList, runningNodeList, failedNodeList);
            if (runningNodeList.size() > 0) {
                if (runningNodeList.contains(m_localHost)) {
                    Trace.out((String)("ASM instance is found configured and running on the local node " + m_localHost));
                    VerificationLogData.log("ASM instance is found configured and running on the local node " + m_localHost);
                    message = s_gMsgBundle.getMessage("4556", false, (Object[])new String[]{m_localHost});
                    localNodeRes.setStatus(1);
                    ReportUtil.sureprintln(message);
                } else {
                    Trace.out((String)("ASM instance was not found running on the local node " + m_localHost));
                    VerificationLogData.log("ASM instance was not found running on the local node " + m_localHost);
                    localNodeRes.setStatus(4);
                    message = s_gMsgBundle.getMessage("4558", true, (Object[])new String[]{VerificationUtil.strCollection2String(runningNodeList), m_localHost});
                    ReportUtil.printWarning(message);
                    localNodeRes.addErrorDescription(new ErrorDescription(message));
                }
            } else {
                Trace.out((String)"ASM instance was not found configured on any of the cluster nodes");
                VerificationLogData.log("ASM instance was not found configured on any of the cluster nodes");
                localNodeRes.setStatus(4);
                message = s_gMsgBundle.getMessage("4559", true);
                ReportUtil.printWarning(message);
                localNodeRes.addErrorDescription(new ErrorDescription(message));
            }
        }
        catch (ASMDiskGroupsUtilException ace) {
            Trace.out((String)("Caught ASMDiskGroupsUtilException : " + ace.getMessage()));
            VerificationLogData.logError("Caught ASMDiskGroupsUtilException : " + ace.getMessage());
            message = s_gMsgBundle.getMessage("4562", true, (Object[])new String[]{ace.getMessage()});
            ReportUtil.printError(message);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
            localNodeRes.setStatus(2);
        }
        asmRsltSet.addResult(m_localHost, localNodeRes);
        asmRsltSet.setStatus();
        return asmRsltSet;
    }

    private ResultSet checkDefaultListenerConfiguration() {
        ResultSet listenerRsltSet = new ResultSet();
        String message = null;
        Result checkLstnrRes = new Result(m_localHost);
        CVUHelperUtil.checkDefaultListener(checkLstnrRes);
        Result localNodeRes = new Result(m_localHost);
        if (checkLstnrRes.getStatus() == 1) {
            Trace.out((String)("Default listener " + m_localHost + " was found configured and running on local node"));
            VerificationLogData.log("Default listener for node " + m_localHost + " was found configured and running on local node");
            message = s_gMsgBundle.getMessage("4557", false, (Object[])new String[]{m_localHost});
            ReportUtil.sureprintln(message);
            localNodeRes.setStatus(1);
        } else if (checkLstnrRes.getStatus() == 4) {
            String resourceRunningNode = "";
            try {
                resourceRunningNode = checkLstnrRes.getActualValue();
            }
            catch (ResultValuesUnavailableException e) {
                Trace.out((String)"Caught ResultValuesUnavailableException: this exception was not expected, Ignoring");
            }
            Trace.out((String)("Default listener for node " + m_localHost + " was found configured but running on node " + resourceRunningNode));
            VerificationLogData.log("Default listener " + m_localHost + " was found configured but running on node " + resourceRunningNode);
            localNodeRes.setStatus(4);
            message = s_gMsgBundle.getMessage("4560", true, (Object[])new String[]{m_localHost, resourceRunningNode});
            ReportUtil.printWarning(message);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
        } else if (checkLstnrRes.getStatus() == 3) {
            Trace.out((String)("Default listener for node " + m_localHost + " was not found configured"));
            VerificationLogData.log("Default listener for node " + m_localHost + " was not found configured");
            localNodeRes.setStatus(4);
            message = s_gMsgBundle.getMessage("4561", false, (Object[])new String[]{m_localHost});
            ReportUtil.printWarning(message);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
        } else {
            String error = "";
            for (VerificationError err : checkLstnrRes.getErrors()) {
                error = error + err.getErrorMessage();
            }
            message = s_gMsgBundle.getMessage("4563", true, (Object[])new String[]{m_localHost, error});
            ReportUtil.printError(message);
            localNodeRes.setStatus(2);
            localNodeRes.addErrorDescription(new ErrorDescription(message));
        }
        listenerRsltSet.addResult(m_localHost, localNodeRes);
        listenerRsltSet.setStatus();
        return listenerRsltSet;
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("4551", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("4550", false);
    }
}

